title Ascii number to binary conversion. coded by wbinvd

        include segments.inc

        extrn   strlen:near,__antob:near

        public  antob

        startcode
;Convert an asciiz string to a binary number in EAX
;In:    EDI     asciiz string with a number in it. May have any base char (XXh)
;Out:   CF=1    Error, not a number (or wrong base)
;         EAX   zero
;       CF=0
;         EAX   the number converted to binary
;Regs:  EAX
antob           proc near
        push    ecx ebx
        call    strlen                  ;Get EDI's length in characters
        jecxz   @@Error
        dec     ecx
        mov     al_,[edi+ecx*CharSize]  ;get last character
        mov     CharType ptr [edi+ecx*CharSize],00h
        push    eax
        push    offset @@666
ifdef UNICODE
        test    ah,ah
        jnz     short @@RestoreLastCharacter
endif
        or      al,20h                  ;lowercase
        mov     bh,10h
        cmp     al,'h'                  ;hexadecimal number?
        je      __antob
        mov     bh,10b
        cmp     al,'b'                  ;binary number?
        je      __antob
        mov     bh,10o
        cmp     al,'o'                  ;octal number?
        je      __antob
        cmp     al,'q'
        je      __antob
        cmp     al,'d'                  ;decimal number?
        je      short @@decimal
@@RestoreLastCharacter:
        mov     eax,[esp+04h]
        mov     [edi+ecx*CharSize],al_  ;restore last character
@@decimal:
        mov     bh,10d                  ;default base is decmial,base 10
        jmp     __antob
@@666:
        pop     ebx                     ;Saved last character
ifdef UNICODE
        mov     [edi+ecx*CharSize],bx
else
        mov     [edi+ecx*CharSize],bl
endif
@@popretn:
        pop     ebx ecx
        ret
@@Error:
        xor     eax,eax
        cmc
        jc      short @@popretn
antob           endp
        endcode
        end
